create or replace package body tbicds.IC_UTL_SEC is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   -- Private constant declarations
   c_nEncryptionType           constant pls_integer := DBMS_CRYPTO.ENCRYPT_AES256
                                                       + DBMS_CRYPTO.CHAIN_CBC
                                                       + DBMS_CRYPTO.PAD_PKCS5;

   -- Function and procedure implementations
   
   /*Execute sql*/
   procedure executeSql (
      pi_vSql                           in varchar2
      )
   is
   begin
      execute immediate pi_vSql;
      commit;

   exception
      when others
      then
         null;
   end;

   /*hash data using data and key*/
   function digest (
      pi_vData                          in varchar2,
      pi_vKey                           in varchar2
      ) return                             varchar2
   is
      v_vKeyValue                          varchar2(2048);
      v_rKey                               raw(32);

      function hashData (
         pi_vData                          in varchar2
         )
         return                               raw
      is
         v_rHashedData                        raw(4000);
      begin
         v_rHashedData := DBMS_CRYPTO.HASH (
                             UTL_I18N.STRING_TO_RAW (pi_vData, 'AL32UTF8'),
                             DBMS_CRYPTO.HASH_SH1
                             );
         return v_rHashedData;

      exception
         when others
         then
            return null;
      end;
   begin
      v_rKey := hashData(upper(pi_vKey));
      v_rKey := UTL_I18N.STRING_TO_RAW (substr(v_rKey, 1, 32), 'AL32UTF8');
      v_vKeyValue := ic_utl_sec.encryptData (pi_vData, v_rKey);
      v_vKeyValue := hashData (v_vKeyValue);
      return v_vKeyValue;
   end;

   /*Encrypt data using data and key passed*/
   function encryptData (
      pi_vData                          in varchar2,
      pi_rKey                           in raw,
      pi_vIndex                         in varchar2 default null
      )
      return                               raw
   is
      v_rEncryptedData                     raw(4000);
      v_rKey                               raw(32);
   begin
      if pi_vIndex is not null
      then
         v_rKey := UTL_I18N.STRING_TO_RAW (rpad(pi_vIndex, 32, pi_vIndex), 'AL32UTF8');
         v_rKey := substr(DBMS_CRYPTO.ENCRYPT (v_rKey, c_nEncryptionType, pi_rKey), 1, 64);
      else
         v_rKey := pi_rKey;
      end if;

      v_rEncryptedData := DBMS_CRYPTO.ENCRYPT (
                             src => UTL_I18N.STRING_TO_RAW (pi_vData, 'AL32UTF8'),
                             typ => c_nEncryptionType,
                             key => v_rKey
                             );

      return v_rEncryptedData;

   exception
      when others
      then
         return pi_vData;
   end;

   /*decrypt data using data and key passed*/
   function decryptData (
      pi_rData                          in raw,
      pi_rKey                           in raw,
      pi_vIndex                         in varchar2 default null
      )
      return                               varchar2
   is
      v_vDecryptedData                     varchar2(4000);
      v_rDecryptedData                     raw(4000);
      v_rKey                               raw(32);
   begin
      if pi_vIndex is not null
      then
         v_rKey := UTL_I18N.STRING_TO_RAW (rpad(pi_vIndex, 32, pi_vIndex), 'AL32UTF8');
         v_rKey := substr(DBMS_CRYPTO.ENCRYPT (v_rKey, c_nEncryptionType, pi_rKey), 1, 64);
      else
         v_rKey := pi_rKey;
      end if;

      v_rDecryptedData := DBMS_CRYPTO.DECRYPT (
                             src => pi_rData,
                             typ => c_nEncryptionType,
                             key => v_rKey
                             );

      v_vDecryptedData := UTL_I18N.RAW_TO_CHAR (v_rDecryptedData, 'AL32UTF8');
      return v_vDecryptedData;

   exception
      when others
      then
         return null;
   end;

  /*translate string to ascii format*/
  function VarcharToAscii (
     strData            in    varchar2
     ) return varchar2
  is
     strChar       varchar2(3);
     strReturn     varchar2(4000);
     i             number;
     nLen          number;
     vErr          varchar2(4000);
  begin

    strReturn := '';
    nLen := length(strData);
    i := 1;

    for i in 1 .. nLen loop

        strChar := substr(strData, i, 1);
        strChar := ascii(strChar);

        while length(strChar) < 3 loop
          strChar := '0' || strChar;
        end loop;

        strReturn := strReturn || strChar;

    end loop;

    return strReturn;

   exception
     when others then
          vErr := 'Error VarcharToAscii';-- sqlCode || ': ' || sqlErrm;
     return '';
   end;

end;
/

